varying vec2 		texcoord;
varying float		dist;
uniform sampler2D 	tex;
uniform sampler2D 	noiseTex;
//uniform vec4		ambientColor;	// ambient  * material color
varying vec4		diffuse;		// diffuse color * material color
varying vec4		fog;
varying float		alphaFade;

varying vec3 	Lin;
varying vec3 	Fex;

#ifdef _HEIGHTMAP_

	uniform sampler2D	cmask;	
	varying vec2 		texcoord2;
	
#endif

void main()
{
	vec4 color=texture2D(tex,texcoord.st);
	
	#ifdef _HEIGHTMAP_
		
		vec3 one=vec3(1.0,1.0,1.0);
		vec3 maskColor=texture2D(cmask,texcoord2.st).rgb;
		vec3 rmul=color.rgb*maskColor;
		vec3 rscr=one-((one-maskColor)*(one-color.rgb));
		color.rgb=color.rgb*rscr+(one-color.rgb)*rmul;
		color.a=1.0;
		//color*=texture2D(cmask,texcoord2.st);
		
	#else
		/*#ifdef BSET
			float alpha=texture2D(noisemap,texcoord.st).r;
			if(alpha>pcolor.w)
				discard;
		#else*/
			float alpha=texture2D(noiseTex,texcoord.st).r;
			if(alpha>alphaFade)
				discard;
		//#endif
	#endif
	
	if(dist<=0.0)
	{
		discard;
	}
	else
	{
		// convert normal to eye space
		//gl_FragColor.xyz=mix(fog.rgb,color.xyz*ambientColor.xyz + color.xyz*diffuse.xyz,fog.a);
		gl_FragColor.xyz=Lin+Fex*diffuse.xyz*color.xyz;
		gl_FragColor.a=color.a;
	}
}
